# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
"""
The facts class for aeos7
this file validates each subset of facts and selectively
calls the appropriate facts gathering function
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.facts.facts import (
    FactsBase,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.interfaces.interfaces import (
    InterfacesFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.l2_interfaces.l2_interfaces import (
    L2_InterfacesFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.vlans.vlans import (
    VlansFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.static_routes.static_routes import (
    Static_RoutesFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.logging_global.logging_global import (
    Logging_globalFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.snmp_server.snmp_server import (
    Snmp_serverFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.hostname.hostname import (
    HostnameFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.lag_interfaces.lag_interfaces import (
    Lag_InterfacesFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.problem_info.problem_info import (
    Problem_InfoFacts,
)
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.facts.legacy.base import (
    Config,
    Default,
    Hardware,
    Interfaces,
)


FACT_LEGACY_SUBSETS = dict(
    default=Default,
    hardware=Hardware,
    interfaces=Interfaces,
    config=Config,
)

FACT_RESOURCE_SUBSETS = dict(
    interfaces=InterfacesFacts,
    l2_interfaces=L2_InterfacesFacts,
    vlans=VlansFacts,
    static_routes=Static_RoutesFacts,
    logging_global=Logging_globalFacts,
    snmp_server=Snmp_serverFacts,
    hostname=HostnameFacts,
    lag_interfaces=Lag_InterfacesFacts,
    problem_info=Problem_InfoFacts,
)


class Facts(FactsBase):
    """The fact class for aeos7"""

    VALID_LEGACY_GATHER_SUBSETS = frozenset(FACT_LEGACY_SUBSETS.keys())
    VALID_RESOURCE_SUBSETS = frozenset(FACT_RESOURCE_SUBSETS.keys())

    def __init__(self, module):
        super(Facts, self).__init__(module)

    def get_facts(self, legacy_facts_type=None, resource_facts_type=None, data=None):
        """Collect the facts for aeos7
        :param legacy_facts_type: List of legacy facts types
        :param resource_facts_type: List of resource fact types
        :param data: previously collected conf
        :rtype: dict
        :return: the facts gathered
        """
        if self.VALID_RESOURCE_SUBSETS:
            self.get_network_resources_facts(
                FACT_RESOURCE_SUBSETS, resource_facts_type, data)

        if self.VALID_LEGACY_GATHER_SUBSETS:
            self.get_network_legacy_facts(
                FACT_LEGACY_SUBSETS, legacy_facts_type)

        return self.ansible_facts, self._warnings
