# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
"""
The aeos7 lag_interfaces fact class
It is in this file the configuration is collected from the device
for a given resource, parsed, and the facts tree is populated
based on the configuration.
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


import re

from ansible_collections.ansible.netcommon.plugins.module_utils.network.common import utils
from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.rm_templates.lag_interfaces import (
    Lag_InterfacesTemplate,
)


class Lag_InterfacesFacts(object):
    """The aeos7 lag_interfaces facts class"""

    def __init__(self, module, subspec="config", options="options"):
        self._module = module

    def get_lag_interfaces_data(self, connection):
        return connection.get("show running-config")

    def populate_facts(self, connection, ansible_facts, data=None):
        """Populate the facts for Lag_interfaces network resource

        :param connection: the device connection
        :param ansible_facts: Facts dictionary
        :param data: previously collected conf

        :rtype: dictionary
        :returns: facts
        """
        facts = {}
        objs = []

        if not data:
            data = self.get_lag_interfaces_data(connection)

        # parse native config using the Lag_interfaces template
        lag_interfaces_parser = Lag_InterfacesTemplate(lines=data.splitlines(), module=self._module)
        objs = lag_interfaces_parser.parse()
        ansible_facts["ansible_network_resources"].pop("lag_interfaces", None)
        facts = {"lag_interfaces": objs}
        ansible_facts["ansible_network_resources"].update(facts)
        return ansible_facts
