# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

"""
The aeos7 logging_global fact class
It is in this file the configuration is collected from the device
for a given resource, parsed, and the facts tree is populated
based on the configuration.
"""

from ansible_collections.ansible.netcommon.plugins.module_utils.network.common import utils

from ansible_collections.apresia.aeos7.plugins.module_utils.network.aeos7.rm_templates.logging_global import (
    Logging_globalTemplate,
)


class Logging_globalFacts(object):
    """The aeos7 logging_global facts class"""

    def __init__(self, module, subspec="config", options="options"):
        self._module = module

    def get_logging_data(self, connection):
        return connection.get("show running-config | include logging")

    def populate_facts(self, connection, ansible_facts, data=None):
        """Populate the facts for Logging_global network resource

        :param connection: the device connection
        :param ansible_facts: Facts dictionary
        :param data: previously collected conf

        :rtype: dictionary
        :returns: facts
        """

        if not data:
            data = self.get_logging_data(connection)

        # parse native config using the Logging_global template
        logging_global_parser = Logging_globalTemplate(
            lines=data.splitlines(), module=self._module)
        objs = logging_global_parser.parse()

        params = utils.remove_empties({"config": objs})

        facts = {"logging_global":  params.get("config", {})}
        ansible_facts["ansible_network_resources"].pop("logging_global", None)
        ansible_facts["ansible_network_resources"].update(facts)

        return ansible_facts
