# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function

__metaclass__ = type

"""
The Hostname parser templates file. This contains
a list of parser definitions and associated functions that
facilitates both facts gathering and native command generation for
the given network resource.
"""

import re
from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.network_template import (
    NetworkTemplate,
)


class InterfacesTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(InterfacesTemplate, self).__init__(
            lines=lines, tmplt=self, module=module
        )

    # fmt: off
    PARSERS = [
        {
            "name": "name",
            "getval": re.compile(
                r"""^interface\sport\s+(?P<port>\S+)$""",
                re.VERBOSE,
            ),
            "compval": "name",
            "result": {
                "port": "\"{{ port }}\""
            },
            "shared": True,
        },
        {
            "name": "shutdown",
            "getval": re.compile(
                r"""\sshutdown
                $""", re.VERBOSE),
            "result": {
                "enabled": False,
            },
        },
        {
            "name": "description",
            "getval": re.compile(
                r"""\sdescription\s+(?P<description>.+)
                $""", re.VERBOSE),
            "result": {
                "description": "{{ description }}",
            },
        },

        {
            "name": "auto-negotiation",
            "getval": re.compile(
                r"""\s(?P<media>\S+)
                (\sauto-negotiation)
                (\sdisable)
                $""", re.VERBOSE),
            "result": {
                "{{ media }}": {
                    "auto_negotiation_disable": True,
                }
            },
        },
        {
            "name": "advertise_delete",
            "getval": re.compile(
                r"""\s(?P<media>\S+)
                (\sadvertise)
                (\sdelete)
                (\s(?P<value>\S+))
                $""", re.VERBOSE),
            "result": {
                "{{ media }}": {
                    "advertise_delete": [
                        "{{ value }}",
                    ]
                }
            },
        },
        {
            "name": "link-speed-duplex",
            "getval": re.compile(
                r"""\s(?P<media>\S+)
                (\slink-speed-duplex)
                (\s(?P<value>\S+))
                $""", re.VERBOSE),
            "result": {
                "{{ media }}": {
                    "link_speed_duplex": "{{ value }}"
                }
            },
        },
        {
            "name": "auto-mdi-x",
            "getval": re.compile(
                r"""\s(?P<media>\S+)
                (\sauto-mdi-x)
                (\sdisable)
                $""", re.VERBOSE),
            "result": {
                "{{ media }}": {
                    "auto_mdi_x_disable": True
                }
            },
        },
        {
            "name": "mdi",
            "getval": re.compile(
                r"""\s(?P<media>\S+)
                (\smdi)
                (\senable)
                $""", re.VERBOSE),
            "result": {
                "{{ media }}": {
                    "mdi_enable": True
                }
            },
        },
        {
            "name": "media",
            "getval": re.compile(
                r"""\smedia
                (\s(?P<media>\S+))
                $""", re.VERBOSE),
            "result": {
                "media": "{{ media }}"
            },
        },
    ]
    # fmt: on



