# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

"""
The L2_Interfaces parser templates file. This contains
a list of parser definitions and associated functions that
facilitates both facts gathering and native command generation for
the given network resource.
"""

import re
from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.network_template import (
    NetworkTemplate,
)


class L2_InterfacesTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(L2_InterfacesTemplate, self).__init__(
            lines=lines, tmplt=self, module=module
        )

    # fmt: off
    PARSERS = [
        {
            "name": "name",
            "getval": re.compile(
                r"""^interface\sport\s+(?P<port>\S+)$""",
                re.VERBOSE,
            ),
            "compval": "name",
            "result": {
                "port": "\"{{ port }}\""
            },
            "shared": True,
        },
        {
            "name": "switchport.mode",
            "getval": re.compile(
                r"""
                \sswitchport\smode
                (\s(?P<mode>access|trunk))
                $""", re.VERBOSE),
            "result": {
                "mode": "{{ mode }}",
            },
        },
        {
            "name": "switchport.access",
            "getval": re.compile(
                r"""
                \sswitchport\saccess\svlan
                (\s(?P<vlan>\d+))
                $""", re.VERBOSE),
            "result": {
                "access_vlan": "{{ vlan }}"
            },
        },
        {
            "name": "switchport.trunk",
            "getval": re.compile(
                r"""
                \sswitchport\strunk
                (((\sadd)
                    (\s(?P<vlan_range>\S+)))
                |((\snative)
                    (\s(?P<native_vlan>\d+)))
                |((\sprotocol)
                    (\s(?P<protocol_vlan>\d+)))
                )
                $""", re.VERBOSE),
            "result": {
                "trunk": {
                    "vlans": "{{ vlan_range if vlan_range is defined }}",
                    "native_vlan": "{{ native_vlan if native_vlan is defined }}",
                    "protocol_vlan": "{{ protocol_vlan if protocol_vlan is defined }}",
                }
            },
        },
    ]
    # fmt: on
