# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

"""
The Logging_global parser templates file. This contains
a list of parser definitions and associated functions that
facilitates both facts gathering and native command generation for
the given network resource.
"""

import re

from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.network_template import (
    NetworkTemplate,
)


class Logging_globalTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(Logging_globalTemplate, self).__init__(
            lines=lines, tmplt=self, module=module
        )

    # fmt: off
    PARSERS = [
        {
            "name": "logging_on",
            "getval": re.compile(
                r"""
                ^no\slogging\son
                $""", re.VERBOSE),
            "result": {
                "logging_on": "{{ 'disable' }}",
            },
        },
        {
            "name": "priority",
            "getval": re.compile(
                r"""
                ^logging
                (\s(?P<output>console|buffered|monitor|sram))
                (\s(?P<priority>\S+))
                $""", re.VERBOSE),
            "result": {
                "priority": {
                    "{{ output }}": "{{ priority }}",
                },
            },
        },
        {
            "name": "source",
            "getval": re.compile(
                r"""
                ^logging\ssource
                (\s(?P<ipv6>ipv6))?
                (\s(?P<address>\S+))
                $""", re.VERBOSE),
            "result": {
                "source": {
                    "ipv4": "{{ address if ipv6 is not defined }}",
                    "ipv6": "{{ address if ipv6 is defined }}",
                },
            },
        },
        {
            "name": "error_frame_received",
            "getval": re.compile(
                r"""
                ^logging\serror-frame-received\sport
                (\s(?P<port_range>\S+))
                (\sdisable)
                $""", re.VERBOSE),
            "result": {
                "error_frame_received_port_disable": "{{ port_range }}"
            },
        },
        {
            "name": "port_description",
            "getval": re.compile(
                r"""
                ^logging\sport\sdescription
                $""", re.VERBOSE),
            "result": {
                "port_descrption": True
            },
        },
        {
            "name": "ip",
            "getval": re.compile(
                r"""
                ^logging\sip
                (\s(?P<address>\S+))
                (\s(?P<facility>\S+))
                (\s(?P<priority>\S+))
                $""", re.VERBOSE),
            "result": {
                "ip": [{
                    "address": "{{ address }}",
                    "facility": "{{ facility }}",
                    "priority": "{{ priority }}",
                }]
            },
        },
        {
            "name": "ipv6",
            "getval": re.compile(
                r"""
                ^logging\sipv6
                (\s(?P<address>\S+))
                (
                    (\s(?P<manage>manage))
                    |(\svlan\s(?P<vid>\S+))
                )?
                (\s(?P<facility>\S+))
                (\s(?P<priority>\S+))
                $""", re.VERBOSE),
            "result": {
                "ipv6": [{
                    "address": "{{ address }}",
                    "facility": "{{ facility }}",
                    "priority": "{{ priority }}",
                    "manage": "{{ True if manage is defined }}",
                    "vlan": "{{ vid if vid is defined }}"
                }]
            },
        },
    ]
    # fmt: on
