# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function
from pickle import FALSE


__metaclass__ = type

"""
The problem_info parser templates file. This contains
a list of parser definitions and associated functions that
facilitates both facts gathering and native command generation for
the given network resource.
"""

import re

from copy import deepcopy
from typing import NamedTuple

from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.network_template import (
    NetworkTemplate,
)
from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.utils import (
    dict_merge,
)


class HardwareProblemTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(HardwareProblemTemplate, self).__init__(lines=lines, tmplt=self, module=module)

    def parse(self):
        def parse_power(line):
            nonlocal power_item
            nonlocal fan_item
            alart = False
            line = line.strip().replace(':', '')
            areas = [item.replace(',', '') for item in line.split()]
            if 'Power' == areas[0] and 'Status' == areas[2]:
                if areas[3] != 'Normal':
                    power_item.update({'Unit' : int(areas[1])})
                    power_item.update({'Status' : areas[3]})
                    alart = True
            idx = 4
            while areas[idx] == 'FAN' and idx < (len(areas) - 2):
                if areas[idx + 2] != 'Normal':
                    fan_item.update({'Unit {0} FAN {1}'.format(areas[1], areas[idx + 1]) : areas[idx + 2]})
                idx += 3
            if areas[idx] == 'Type':
                if alart:
                    power_item.update({'Type' : areas[idx + 1]})

        def parse_fan(line):
            nonlocal fan_item
            line = line.strip().replace(':', '')
            areas = line.split()
            if 'FAN' == areas[0] and 'Normal' != areas[2]:
                fan_item.update({'FAN {0}'.format(areas[1]) : areas[2]})

        def parse_recovery_count(line):
            nonlocal mem_item
            line = line.strip().replace(':', '')
            areas = line.split()
            if 'Recovery' == areas[0] and 'Count' == areas[1]:
                fan_item.update({'Recovery Count' : int(areas[2])})
            elif 'ECC' == areas[0] and 'Error' == areas[2]:
                fan_item.update({'ECC Uncorrectable Error' : int(areas[3])})
                
        
        """parse"""
        result = {}
        result_item = {}
        power_list = []
        power_item = {}
        fan_item = {}
        temp_item = {}
        mem_item = {}
        iter_lines = iter(self._lines)
        for line in iter_lines:
            if len(line) == 0:
                continue
            if 'POWER' in line:
                while (subline := next(iter_lines, None)):
                    parse_power(subline)
                    if len(power_item) > 0:
                        power_list.append(power_item)
                        power_item = {}
            elif 'FAN' in line:
                while (subline := next(iter_lines, None)):
                    parse_fan(subline)
            elif 'TEMPERATURE' in line:
                subline = next(iter_lines, None)
                if subline is None:
                    break
                if 'Normal' in subline:
                    continue
                temp_item = {"TEMPERATURE:" : {"Status" : subline.strip()}}
            elif 'SW-LSI MEMORY Status' in line:
                subline = next(iter_lines, None)
                if subline is None:
                    break
                if 'Normal' in subline:
                    break
                mem_item = {"Status" : subline.strip()}
                while (subline := next(iter_lines, None)):
                    parse_recovery_count(subline)
        if len(power_list) > 0:
            result_item["POWER"] = power_list
        if len(fan_item) > 0:
            result_item["FAN"] = fan_item
        if len(temp_item) > 0:
            result_item.update(temp_item)
        if len(mem_item) > 0:
            result_item["SW_LSI_MEMORY"] = mem_item
        if len(result_item) > 0:
            result = {"hardware" : result_item}
        return result


class SystemProblemTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(SystemProblemTemplate, self).__init__(lines=lines, tmplt=self, module=module)

    def parse(self):
        def parse_health_status(line):
            nonlocal result
            line = line.strip().replace(':', '')
            areas = line.split()
            if 'Health' == areas[0] and 'Status' == areas[1]:
                result.update({'Health Status' : areas[2]})
                res = re.findall(r'\((.+?)\)', areas[2])
                result.update({'Health Status Valus' : res[0]})

        """parse"""
        result = {}
        iter_lines = iter(self._lines)
        for line in iter_lines:
            if len(line) == 0:
                continue
            parse_health_status(line)
        if len(result) == 0:
            result = None
        return result
