# -*- coding: utf-8 -*-
# Copyright 2021 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

"""
The Snmp_server parser templates file. This contains
a list of parser definitions and associated functions that
facilitates both facts gathering and native command generation for
the given network resource.
"""

import re

from ansible_collections.ansible.netcommon.plugins.module_utils.network.common.rm_base.network_template import (
    NetworkTemplate,
)


class Snmp_serverTemplate(NetworkTemplate):
    def __init__(self, lines=None, module=None):
        super(Snmp_serverTemplate, self).__init__(
            lines=lines, tmplt=self, module=module
        )

    # fmt: off
    PARSERS = [
 
        {
            "name": "disable",
            "getval": re.compile(
                r"""
                ^snmp-server\sdisable
                $""", re.VERBOSE),
            "result": {
                "enabled": False
            },
        },
        {
            "name": "ipv4.communities",
            "getval": re.compile(
                r"""
                ^snmp-server\scommunity
                (\s(?P<mode>ro|rw))
                (\s(?P<name>(((\S+?)?(\".*?\")(\S+)?)|\S+)))
                (\s(?P<ipaddr>\S+))
                """, re.VERBOSE),
            "result": {
                "ipv4": {
                    "communities": [{
                        "rw": "{{ True if mode == 'rw' else False }}",
                        "name": "{{ name }}",
                        "ipaddr": "{{ ipaddr if ipaddr is defined }}",
                    }],
                }
            },
        },
        {
            "name": "ipv6.communities",
            "getval": re.compile(
                r"""
                ^snmp-server\sipv6\scommunity
                (\s(?P<mode>ro|rw))
                (\s(?P<name>(((\S+?)?(\".*?\")(\S+)?)|\S+)))
                (\s(?P<ipv6addr>\S+?))
                (
                    (\s(?P<interface>loopback|manage))
                    |(\svlan\s(?P<vlan>\d+))
                )?
                $""", re.VERBOSE),
            "result": {
                "ipv6": {
                    "communities": [{
                        "rw": "{{ True if mode == 'rw' else False }}",
                        "name": "{{ name }}",
                        "ipaddr": "{{ ipv6addr }}",
                        "interface": "{{ interface if interface is defined }}",
                        "vlan": "{{ vlan if vlan is defined }}"
                    }],
                }
            },
        },
        {
            "name": "access_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\saccess-disable
                (\s(?P<value>read-write|write))
                $""", re.VERBOSE),
            "result": {
                "access_disable": "{{ value }}"
            },
        },
        {
            "name": "ipv4.host",
            "getval": re.compile(
                r"""
                ^snmp-server\shost
                (\s(?P<name>(((\S+?)?(\".*?\")(\S+)?)|\S+)))
                (\s(?P<ipaddr>\S+))
                (\sversion\s(?P<version>1|2|3))?
                $""", re.VERBOSE),
            "result": {
                "ipv4": {
                    "hosts": [{
                        "name": "{{ name }}",
                        "ipaddr": "{{ ipaddr }}",
                        "version": "{{ version if version is defined else 1 }}"
                    }],
                },
            },
        },
        {
            "name": "ipv6.host",
            "getval": re.compile(
                r"""
                ^snmp-server\sipv6\shost
                (\s(?P<name>(((\S+?)?(\".*?\")(\S+)?)|\S+)))
                (\s(?P<ipaddr>\S+))
                (
                    (\s(?P<interface>loopback|manage))
                    |(\svlan\s(?P<vlan>\d+))
                )?
                (\sversion\s(?P<version>1|2|3))?
                $""", re.VERBOSE),
            "result": {
                "ipv6": {
                    "hosts": [{
                        "name": "{{ name }}",
                        "ipaddr": "{{ ipaddr }}",
                        "interface": "{{ interface if interface is defined }}",
                        "version": "{{ version if version is defined else 1 }}",
                        "vlan": "{{ vlan if vlan is defined }}",
                    }],
                },
            },
        },
        {
            "name": "ipv4.trap_source",
            "getval": re.compile(
                r"""
                ^snmp-server\strap\ssource
                (\s(?P<ipaddr>\S+))
                $""", re.VERBOSE),
            "result": {
                "ipv4": {
                    "trap_source": "{{ ipaddr }}"
                },
            },
        },
        {
            "name": "trap_agent_addr_vbip",
            "getval": re.compile(
                r"""
                ^snmp-server\strap\sagent-addr-vbip
                $""", re.VERBOSE),
            "result": {
                "agent_addr_vbip": "{{ True }}"
            },
        },
        {
            "name": "traps.authentication_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sauthentication\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "authentication_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.cold_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\scold\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "cold_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.cpu_utilization_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\scpu-utilization\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "cpu_utilization_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.fan_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sfan\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "fan_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.lacp_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slacp\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "lacp_enable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.loop_watch_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sloop-watch\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "loop_watch_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.login_incorrect_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slogin-incorrect\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "login_incorrect_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.mac_address_table_notify_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smac-address-table-notify\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "mac_address_table_notify_enable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.frequent_station_move_notify_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sfrequent-station-move-notify\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "frequent_station_move_notify_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.memory_error_auto_recovery_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smemory-error\sauto-recovery\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "memory_error_auto_recovery_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.memory_error_cannotbefixed_error_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smemory-error\scannotbefixed-error\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "memory_error_cannotbefixed_error_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.memory_error_temporary_error_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smemory-error\stemporary-error\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "memory_error_temporary_error_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.memory_used_notify_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smemory-used-notify\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "memory_used_notify_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.mlag_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smlag\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "mlag_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.lag_if_state_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slag\sif-state\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "lag_if_state_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.lag_port_state_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slag\sport-state\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "lag_port_state_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.mmrp_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\smmrp\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "mmrp_enable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.pbr_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\spbr\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "pbr_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.poe_enable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\spoe\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "poe_enable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.poe_system_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\spoe-system\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "poe_system_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.power_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\spower\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "power_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.sfp_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\ssfp\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "sfp_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.system_error_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\ssystem-error\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "system_error_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.system_status_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\ssystem-status\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "system_status_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.temperature_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\stemperature\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "temperature_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.topology_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\stopology\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "topology_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.vb_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\svb\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "vb_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.vrrp_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\svrrp\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "vrrp_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.flooding_control_disable",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sflooding\scontrol\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "flooding_control_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "contact",
            "getval": re.compile(
                r"""
                ^snmp-server\scontact
                (\s(?P<value>.+))
                $""", re.VERBOSE),
            "result": {
                "contact": "{{ value }}",
            },
        },
        {
            "name": "location",
            "getval": re.compile(
                r"""
                ^snmp-server\slocation
                (\s(?P<value>.+))
                $""", re.VERBOSE),
            "result": {
                "location": "{{ value }}",
            },
        },
        {
            "name": "name",
            "getval": re.compile(
                r"""
                ^snmp-server\sname
                (\s(?P<value>.+))
                $""", re.VERBOSE),
            "result": {
                "name": "{{ value }}",
            },
        },
        {
            "name": "response_delay_time",
            "getval": re.compile(
                r"""
                ^snmp-server\sresponse-delay-time
                (\s(?P<msec>.+))
                $""", re.VERBOSE),
            "result": {
                "response_delay_time": "{{ msec }}",
            },
        },
        {
            "name": "trap_source",
            "getval": re.compile(
                r"""
                ^snmp-server\strap-source\sinterface\svlan
                (\s(?P<vid>\S+))
                $""", re.VERBOSE),
            "result": {
                "trap_source": "vlan {{ vid }}",
            },
        },
        {
            "name": "traps.boot_time_delay",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\sboot-time-delay
                (\s(?P<seconds>\S+))
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "boot_time_delay": "{{ seconds }}",
                },
            },
        },
        {
            "name": "traps.transmit_delay",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\stransmit-delay
                (\s(?P<seconds>\S+))
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "transmit_delay": "{{ seconds }}",
                },
            },
        },
        {
            "name": "traps.user_port_number",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\suser-port-number\senable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "user_port_number_enable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.error_frame_threshold",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\serror-frame-threshold\sport
                (\s(?P<port_range>\S+))
                \sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "error_frame_threshold_disabled_ports": "{{ port_range }}",
                },
            },
        },
        {
            "name": "traps.error_frame_received",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\serror-frame-received\sport
                (\s(?P<port_range>\S+))
                \sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "error_frame_received_disabled_ports": "{{ port_range }}",
                },
            },
        },
        {
            "name": "traps.link_manage",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slink\smanage\sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "link_manage_disable": "{{ True }}",
                },
            },
        },
        {
            "name": "traps.link_port",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slink\sport
                (\s(?P<port_range>\S+))
                \sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "link_disabled_ports": "{{ port_range }}",
                },
            },
        },
        {
            "name": "traps.link_ignore",
            "getval": re.compile(
                r"""
                ^snmp-server\straps\slink-ignore\sport
                (\s(?P<port_range>\S+))
                \sdisable
                $""", re.VERBOSE),
            "result": {
                "traps": {
                    "link_ignore_disabled_ports": "{{ port_range }}",
                },
            },
        },
        {
            "name": "rmon-history",
            "getval": re.compile(
                r"""
                ^snmp-server\srmon-history\sdefault-entry\senable
                $""", re.VERBOSE),
            "result": {
                "rmon_history_default_entry_enable": "{{ True }}",
            },
        },
        {
            "name": "v3_only",
            "getval": re.compile(
                r"""
                ^snmp-server\sv3\sonly
                $""", re.VERBOSE),
            "result": {
                "v3_only": "{{ True }}",
            },
        },
        {
            "name": "engine_id",
            "getval": re.compile(
                r"""
                ^snmp-server\sengine-id
                (\s(?P<id>.+))
                $""", re.VERBOSE),
            "result": {
                "engine_id": "{{ id }}",
            },
        },
        {
            "name": "groups",
            "getval": re.compile(
                r"""
                ^snmp-server
                (\sgroup\s(?P<group>(\S+)?(".*?")?(\S+)?))
                (\s(?P<security_level>noauth|auth|priv))
                (\sread\s(?P<read_view_name>(\S+)?(".*?")?(\S+)?))
                (\swrite\s(?P<write_view_name>(\S+)?(".*?")?(\S+)?))
                (\snotify\s(?P<notify_view_name>(\S+)?(".*?")?(\S+)?))
                $""", re.VERBOSE),
            "result": {
                "groups": [{
                    "group": "{{ group }}",
                    "security_level": "{{ security_level }}",
                    "read": "{{ read_view_name }}",
                    "write": "{{ write_view_name }}",
                    "notify": "{{ notify_view_name }}",
                }],
            },
        },
        {
            "name": "users",
            "getval": re.compile(
                r"""
                ^snmp-server\sencrypted-user
                (\s(?P<user>".*?"))
                (\s(?P<group>".*?"))
                (\s(?P<auth_type>md5|sha)\s(?P<auth_pass>".*?"))?
                (\s(?P<priv_type>aes|des)\s(?P<priv_pass>".*?"))?
                $""", re.VERBOSE),
            "result": {
                "users": [{
                    "username": "{{ user }}",
                    "group": "{{ group }}",
                    "auth_type": "{{ auth_type if auth_type is defined }}",
                    "auth_pass": "{{ auth_pass if auth_pass is defined }}",
                    "priv_type": "{{ priv_type if priv_type is defined }}",
                    "priv_pass": "{{ priv_pass if priv_pass is defined }}",
                }],
            },
        },
        {
            "name": "views",
            "getval": re.compile(
                r"""
                ^snmp-server\sview
                (\s(?P<name>\S+))
                (\s(?P<oid_tree>\S+))
                (\s(?P<type_select>include|exclude))?
                (\smask\s(?P<mask>\S+))?
                $""", re.VERBOSE),
            "result": {
                "views": [{
                    "view_name": "{{ name }}",
                    "oid_tree": "\"{{ oid_tree }}\"",
                    "type": "{{ type_select if type_select is defined else 'include' }}",
                    "mask": "\"{{ mask }}\"",
                }],
            },
        },
    ]
    # fmt: on
